/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class AbstractInfoScreen
extends Canvas {
    private Display display;
    private Image image;
    private String text;
    private Font DEFAULT_TEXT_FONT;
    private Font textFont;
    private Display previouslyShownDisplayable;
    private Displayable nextDisplayable;
    private Alert nextAlert;
    private Displayable previousDisplayable;

    public AbstractInfoScreen(Display display) throws IllegalArgumentException {
        this.textFont = this.DEFAULT_TEXT_FONT = Font.getFont((int)0);
        if (display == null) {
            throw new IllegalArgumentException("Display parameter cannot be null.");
        }
        this.display = display;
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setTextFont(Font font) {
        this.textFont = font != null ? font : this.DEFAULT_TEXT_FONT;
        this.repaint();
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setNextDisplayable(Displayable nextDisplayable) {
        this.nextDisplayable = nextDisplayable;
    }

    public void setNextDisplayable(Alert nextAlert, Displayable nextDisplayable) throws IllegalArgumentException {
        if (nextAlert != null && nextDisplayable == null) {
            throw new IllegalArgumentException("A nextDisplayable parameter cannot be null if the nextAlert parameter is not null.");
        }
        if (nextDisplayable instanceof Alert) {
            throw new IllegalArgumentException("nextDisplayable paremter cannot be Alert.");
        }
        this.nextAlert = nextAlert;
        this.nextDisplayable = nextDisplayable;
    }

    protected void paint(Graphics g) {
        g.setColor(this.display.getColor(0));
        g.fillRect(0, 0, g.getClipWidth(), g.getClipHeight());
        g.setColor(this.display.getColor(1));
        int centerX = g.getClipWidth() / 2 + g.getClipX();
        int centerY = g.getClipHeight() / 2 + g.getClipY();
        if (this.image != null) {
            g.drawImage(this.image, centerX, centerY, 3);
        }
        if (this.text != null) {
            g.drawString(this.text, centerX, centerY, 65);
        }
    }

    protected void sizeChanged(int w, int h) {
        this.repaint();
    }

    protected Display getDisplay() {
        return this.display;
    }

    protected Displayable getNextDisplayable() {
        return this.nextDisplayable;
    }

    protected Alert getNextAlert() {
        return this.nextAlert;
    }

    protected void switchToNextDisplayable() {
        if (this.nextDisplayable != null) {
            AbstractInfoScreen.switchToDisplayable(this.display, this.nextAlert, this.nextDisplayable);
        } else if (this.previousDisplayable != null) {
            this.display.setCurrent(this.previousDisplayable);
        }
    }

    protected static void switchToDisplayable(Display display, Alert alert, Displayable displayable) {
        if (displayable != null) {
            if (alert != null) {
                display.setCurrent(alert, displayable);
            } else {
                display.setCurrent(displayable);
            }
        }
    }

    protected void showNotify() {
        this.previousDisplayable = this.getDisplay().getCurrent();
        super.showNotify();
    }
}

