/*
 * Decompiled with CFR 0.152.
 */
package hello;

import gexpa.Element;
import gexpa.Parser;
import hello.HelloMidlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class FogoCanvas
extends GameCanvas {
    private Graphics gbuf;
    private BackgroundTask bgTask;
    private HelloMidlet midlet;
    protected Image currentPhoto;
    int photoDelay;

    public FogoCanvas(boolean b, HelloMidlet m) {
        super(b);
        this.midlet = m;
        this.setFullScreenMode(true);
    }

    public void startShow(String tag, int delay) {
        this.photoDelay = delay;
        this.bgTask = new BackgroundTask(this, tag, delay);
        this.bgTask.start();
    }

    public void shutDown() {
        this.bgTask.stop();
        Display.getDisplay((MIDlet)this.midlet).setCurrent(null);
        this.midlet.notifyDestroyed();
    }

    public void paint(Graphics g) {
        if (this.currentPhoto != null) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.currentPhoto, this.getWidth() / 2, this.getHeight() / 2, 3);
        } else {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 255, 255);
            String msg = "Loading..";
            Font f = Font.getDefaultFont();
            g.drawString(msg, this.getWidth() / 2, this.getHeight() / 2, 17);
        }
    }

    boolean leftSoftkeyPressed(int keyCode) {
        String name = this.getKeyName(keyCode).toLowerCase();
        boolean answer = false;
        if (this.getGameAction(keyCode) == 0) {
            if (name.equals("soft1")) {
                answer = true;
            }
            if (name.startsWith("left")) {
                answer = true;
            }
        }
        return answer;
    }

    boolean rightSoftkeyPressed(int keyCode) {
        String name = this.getKeyName(keyCode).toLowerCase();
        boolean answer = false;
        if (this.getGameAction(keyCode) == 0) {
            if (name.equals("soft2")) {
                answer = true;
            }
            if (name.startsWith("right")) {
                answer = true;
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(int keyCode) {
        Object object;
        int action = this.getGameAction(keyCode);
        if (action == 5) {
            this.bgTask.direction = 1;
            this.bgTask.navigating = true;
            this.bgTask.paused = true;
            object = this.bgTask.wakeUp;
            synchronized (object) {
                this.bgTask.wakeUp.notify();
            }
        }
        if (action == 2) {
            this.bgTask.direction = -1;
            this.bgTask.navigating = true;
            this.bgTask.paused = true;
            object = this.bgTask.wakeUp;
            synchronized (object) {
                this.bgTask.wakeUp.notify();
            }
        }
        if (action == 8) {
            if (this.bgTask.paused) {
                this.bgTask.paused = false;
                this.bgTask.direction = 1;
            } else {
                this.bgTask.direction = 1;
                this.bgTask.paused = true;
            }
            object = this.bgTask.wakeUp;
            synchronized (object) {
                this.bgTask.wakeUp.notify();
            }
        }
        if (this.leftSoftkeyPressed(keyCode) || this.rightSoftkeyPressed(keyCode)) {
            this.bgTask.stop();
            object = this.bgTask.wakeUp;
            synchronized (object) {
                this.bgTask.wakeUp.notify();
            }
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.get_helloForm());
        }
    }

    class BackgroundTask
    extends Thread {
        boolean done;
        FogoCanvas fg;
        Graphics gbuf;
        BackgroundTask me;
        Vector photos;
        String tag;
        Object wakeUp = new Object();
        int delay;
        int idx = 0;
        int direction = 1;
        boolean paused;
        boolean navigating;

        BackgroundTask(FogoCanvas fogoCanvas2, String tagName, int del) {
            this.fg = fogoCanvas2;
            this.tag = tagName;
            this.delay = del;
            this.direction = 1;
            this.paused = false;
            this.navigating = false;
        }

        void setRequestHeaders(HttpConnection c) throws IOException {
            String conf = System.getProperty("microedition.configuration");
            String prof = System.getProperty("microedition.profiles");
            String locale = System.getProperty("microedition.locale");
            String ua = "Profile/" + prof + " Configuration/" + conf;
            c.setRequestProperty("User-Agent", ua);
            if (locale != null) {
                c.setRequestProperty("Content-Language", locale);
            }
        }

        String nnFormat(int n) {
            String num = "0" + Integer.toString(n);
            int i = num.length();
            return num.substring(i - 2, i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String url;
            Graphics gbuf = this.fg.getGraphics();
            this.done = false;
            if (!this.tag.equals("")) {
                this.tag = this.tag.replace(' ', ',');
                url = "http://www.flickr.com/services/rest/?method=flickr.photos.search&api_key=9f0e5fe57b77824e9d131a1ec4c76555&tag_mode=all&tags=" + this.tag;
            } else {
                url = "http://www.flickr.com/services/rest/?method=flickr.interestingness.getList&api_key=9f0e5fe57b77824e9d131a1ec4c76555&per_page=50";
            }
            String buff = "";
            Parser p = new Parser();
            try {
                HttpConnection connection = (HttpConnection)Connector.open((String)url);
                this.setRequestHeaders(connection);
                InputStream istream = connection.openInputStream();
                Element e = p.parse(new InputStreamReader(istream));
                e = e.getChild("photos");
                this.photos = e.getChildren("photo");
                connection.close();
                if (this.photos.size() == 0) {
                    gbuf.setColor(0, 0, 0);
                    gbuf.fillRect(0, 0, this.fg.getWidth(), this.fg.getHeight());
                    gbuf.setColor(255, 255, 255);
                    String msg = "No Pictures Found.";
                    Font f = Font.getDefaultFont();
                    gbuf.drawString(msg, this.fg.getWidth() / 2, this.fg.getHeight() / 2, 17);
                    this.fg.flushGraphics();
                    this.done = true;
                }
            }
            catch (Exception e) {
                Display.getDisplay((MIDlet)FogoCanvas.this.midlet).setCurrent(FogoCanvas.this.midlet.get_alert1(), (Displayable)FogoCanvas.this.midlet.get_helpForm());
                return;
            }
            while (!this.done) {
                Element photo = (Element)this.photos.elementAt(this.idx);
                String id = photo.getAttribute("id");
                String title = photo.getAttribute("title");
                String secret = photo.getAttribute("secret");
                String server = photo.getAttribute("server");
                String picurl = "http://static.flickr.com/" + server + "/" + id + "_" + secret + "_m.jpg";
                try {
                    long t0 = System.currentTimeMillis();
                    HttpConnection imgcon = (HttpConnection)Connector.open((String)picurl);
                    this.setRequestHeaders(imgcon);
                    this.fg.currentPhoto = Image.createImage((InputStream)imgcon.openInputStream());
                    imgcon.close();
                    gbuf.setColor(0, 0, 0);
                    gbuf.fillRect(0, 0, this.fg.getWidth(), this.fg.getHeight());
                    gbuf.setColor(255, 255, 255);
                    gbuf.drawImage(this.fg.currentPhoto, this.fg.getWidth() / 2, this.fg.getHeight() / 2, 3);
                    this.fg.flushGraphics();
                    long t1 = System.currentTimeMillis();
                    Object object = this.wakeUp;
                    synchronized (object) {
                        try {
                            if (this.delay < 0) {
                                this.wakeUp.wait();
                            } else if (!this.paused) {
                                long dtime = (long)(this.delay * 1000) - (t1 - t0);
                                if (dtime < 0L) {
                                    dtime = 0L;
                                }
                                this.wakeUp.wait((long)(this.delay * 1000) - (t1 - t0));
                                if (this.paused) {
                                    Image img = Image.createImage((String)"/hello/pause.png");
                                    this.fg.getGraphics().drawImage(img, this.fg.getWidth() / 2 - 16, this.fg.getHeight() - 32, 0);
                                    this.fg.flushGraphics();
                                    if (!this.navigating) {
                                        this.wakeUp.wait();
                                    } else {
                                        this.navigating = false;
                                    }
                                }
                            } else {
                                Image img = Image.createImage((String)"/hello/pause.png");
                                this.fg.getGraphics().drawImage(img, this.fg.getWidth() / 2 - 16, this.fg.getHeight() - 32, 0);
                                this.fg.flushGraphics();
                                this.wakeUp.wait();
                                this.navigating = false;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception e) {
                    Display.getDisplay((MIDlet)FogoCanvas.this.midlet).setCurrent(FogoCanvas.this.midlet.get_alert1(), (Displayable)FogoCanvas.this.midlet.get_helpForm());
                    this.done = true;
                }
                this.idx = (this.idx + this.direction) % this.photos.size();
                if (this.idx >= 0) continue;
                this.idx += this.photos.size();
            }
        }

        public void stop() {
            this.done = true;
        }
    }
}

