/*
 * Decompiled with CFR 0.152.
 */
package gexpa;

import gexpa.Element;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLOutput {
    private Writer out;
    private boolean format = false;
    private String elementPrefix = "";
    private int ident = -1;
    private static final char OPEN_TAG = '<';
    private static final char CLOSE_TAG = '>';

    private void print(String message) throws IOException {
        this.out.write(message.toCharArray());
    }

    private void printIdent() throws IOException {
        for (int i = 0; i < this.ident; ++i) {
            this.print("\t");
        }
    }

    private String encode(String text) {
        StringBuffer sb = new StringBuffer();
        sb.ensureCapacity(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public void output(Writer out, Element element) throws IOException {
        this.out = out;
        this._output(element);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _output(Element element) throws IOException {
        ++this.ident;
        try {
            if (this.format) {
                this.print(this.elementPrefix);
                this.printIdent();
            }
            this.print('<' + element.getName());
            this.elementPrefix = "\n";
            Hashtable attributes = element.getAttributes();
            Enumeration names = attributes.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = (String)attributes.get(name);
                this.print(" " + name + "=\"" + this.encode(value) + "\"");
            }
            if (this.isEmpty(element.getText()) && element.getChildren().size() == 0) {
                this.print("/>");
                return;
            }
            this.print(">");
            String text = this.encode(element.getText());
            this.print(text);
            if (text.length() > 0) {
                this.elementPrefix = "";
            }
            Vector elements = element.getChildren();
            for (int i = 0; i < elements.size(); ++i) {
                Element e = (Element)elements.elementAt(i);
                this._output(e);
            }
            if (this.format) {
                this.print(this.elementPrefix);
            }
            if (this.format && this.elementPrefix.length() > 0) {
                this.printIdent();
            }
            this.elementPrefix = "\n";
            this.print("</" + element.getName() + '>');
        }
        finally {
            --this.ident;
        }
    }

    public void setFormatting(boolean format) {
        this.format = format;
    }
}

