/*
 * Decompiled with CFR 0.152.
 */
package gexpa;

import gexpa.BuildEventListener;
import gexpa.DOMBuilder;
import gexpa.Element;
import gexpa.ParseException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;

public final class Parser {
    private char c;
    private char nc;
    private char nc1;
    private char nc2;
    private Reader in;
    private static final char EOF = '\uffff';
    private final Hashtable entities = new Hashtable();
    private final StringBuffer sbEntity = new StringBuffer();
    private int charactersRead = 0;
    private static final byte ELEMENT_NAME = 0;
    private static final byte ATTRIBUTE_NAME = 1;
    private static final byte ATTRIBUTE_VALUE = 2;
    private static final byte CLOSE_ELEMENT = 3;
    private static final byte UNKNOWN = 4;
    private static final byte TEXT = 5;
    private static final byte PREAMPLE = 6;
    private static final byte XML_DECLARATION = 7;
    private byte expect = (byte)6;
    private String currentElementName = "";
    private StringBuffer currentElementText = new StringBuffer();
    private String attributeName = "";
    private StringBuffer attributeValue = new StringBuffer();
    private BuildEventListener listener;
    private final Vector elements = new Vector();

    private void lessThan() {
        this.expect = 0;
    }

    private void greaterThan() {
        if (this.expect != 3 && this.expect != 7) {
            this.listener.endElementDeclaration(this.currentElementName);
        }
        this.expect = (byte)5;
    }

    private void quotes() {
        switch (this.expect) {
            case 2: {
                String value = this.attributeValue.toString();
                this.attributeValue.setLength(0);
                this.listener.attribute(this.attributeName, value);
                this.attributeName = "";
                this.expect = 1;
                return;
            }
            case 4: {
                this.expect = (byte)2;
                return;
            }
            case 5: {
                this.currentElementText.append('\"');
                return;
            }
        }
    }

    private void closeTag() {
        this.expect = (byte)3;
    }

    private void closeSingelton() {
        this.expect = (byte)3;
        this.listener.endElementDeclaration(this.currentElementName);
        this.identifier("");
        this.expect = (byte)5;
    }

    private void identifier(String identifier) {
        switch (this.expect) {
            case 3: {
                String text = this.currentElementText.toString();
                this.currentElementText.setLength(0);
                this.listener.elementText(text);
                this.listener.closeElement(this.currentElementName);
                this.elements.removeElementAt(this.elements.size() - 1);
                this.currentElementName = (String)this.elements.elementAt(this.elements.size() - 1);
                break;
            }
            case 0: {
                this.listener.elementText(this.currentElementText.toString());
                this.currentElementName = this.trimBlanks(identifier);
                if (this.currentElementName.length() == 0) {
                    return;
                }
                this.elements.addElement(this.currentElementName);
                this.listener.startElementDeclaration(this.currentElementName);
                this.currentElementText.setLength(0);
                this.expect = 1;
                break;
            }
            case 1: {
                this.attributeName = this.trimBlanks(identifier);
                if (this.attributeName.length() == 0) {
                    return;
                }
                this.expect = (byte)4;
                break;
            }
            case 2: {
                this.attributeValue.append(identifier);
                this.expect = (byte)2;
                break;
            }
            case 5: {
                this.currentElementText.append(identifier);
            }
        }
    }

    private String trimBlanks(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return string.substring(i);
        }
        return "";
    }

    private void start() {
        this.elements.addElement("");
        this.listener.startDocument();
    }

    private void finish() {
        this.listener.finishDocument();
    }

    private void questionmark() {
        switch (this.expect) {
            case 0: {
                this.expect = (byte)7;
                return;
            }
            case 5: {
                this.currentElementText.append('?');
                return;
            }
        }
    }

    private void setupDefaultEntities() {
        this.entities.put("amp", "&");
        this.entities.put("lt", "<");
        this.entities.put("gt", ">");
    }

    public void addNamedEntity(String entity, String substitute) {
        this.entities.put(entity, substitute);
    }

    private String decodeEntity(String entity) throws ParseException {
        String substitute = (String)this.entities.get(entity);
        if (substitute != null) {
            return substitute;
        }
        return "&" + entity + ";";
    }

    private void read() throws IOException {
        this.c = this.nc;
        int i = this.in.read();
        ++this.charactersRead;
        this.nc = this.nc1;
        this.nc1 = this.nc2;
        this.nc2 = (char)i;
    }

    private boolean isSpecialCharacter(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\"' || c == '/' || c == '<' || c == '>' || c == '=' || c == '?';
    }

    private String readEntity() throws IOException, ParseException {
        while (true) {
            this.read();
            switch (this.c) {
                case ';': {
                    String entity = this.sbEntity.toString();
                    this.sbEntity.setLength(0);
                    return entity;
                }
                case '\uffff': {
                    throw new ParseException("Unexpected EOF", "character " + this.charactersRead);
                }
            }
            this.sbEntity.append(this.c);
        }
    }

    private String readCDATA() throws IOException, ParseException {
        this.read("<![CDATA[");
        StringBuffer sb = new StringBuffer();
        while (this.c != ']' || this.nc != ']' || this.nc1 != '>') {
            if (this.c == '\uffff') {
                throw new EOFException();
            }
            sb.append(this.c);
            this.read();
        }
        this.read();
        this.read();
        return sb.toString();
    }

    private void read(String s) throws IOException, ParseException {
        for (int i = 0; i < s.length(); ++i) {
            if (this.c == '\uffff') {
                throw new EOFException();
            }
            char c1 = s.charAt(i);
            if (c1 != this.c) {
                throw new ParseException("expected " + c1 + "! in CDATA", "");
            }
            this.read();
        }
    }

    private void skipComment() throws IOException {
        while (true) {
            if (this.c == '-' && this.nc == '-' && this.nc1 == '>') {
                this.read();
                this.read();
                this.read();
                return;
            }
            this.read();
        }
    }

    public void parse(Reader in, BuildEventListener listener) throws IOException, ParseException {
        this.in = in;
        StringBuffer sb = new StringBuffer();
        this.listener = listener;
        this.start();
        this.read();
        this.read();
        this.read();
        this.read();
        block9: while (true) {
            switch (this.c) {
                case '\uffff': {
                    this.finish();
                    return;
                }
                case '<': {
                    if (this.nc == '!') {
                        if (this.nc1 == '-' && this.nc2 == '-') {
                            this.skipComment();
                            continue block9;
                        }
                        if (this.nc1 == '[' && this.nc2 == 'C') {
                            String text = this.readCDATA();
                            listener.elementText(text);
                            continue block9;
                        }
                    }
                    if (this.nc == '/') {
                        this.closeTag();
                        this.read();
                        break;
                    }
                    this.lessThan();
                    break;
                }
                case '>': {
                    this.greaterThan();
                    break;
                }
                case '/': {
                    if (this.nc == '>') {
                        this.closeSingelton();
                        this.read();
                        break;
                    }
                    sb.append(this.c);
                    break;
                }
                case '\"': {
                    this.quotes();
                    break;
                }
                case '?': {
                    this.questionmark();
                    break;
                }
                case '&': {
                    String entity = this.readEntity();
                    entity = this.decodeEntity(entity);
                    sb.append(entity);
                    break;
                }
                default: {
                    sb.append(this.c);
                    if (!this.isSpecialCharacter(this.nc)) break;
                    String id = sb.toString();
                    sb.setLength(0);
                    this.identifier(id);
                }
            }
            this.read();
        }
    }

    public Element parse(Reader in) throws IOException, ParseException {
        DOMBuilder dbuilder = new DOMBuilder();
        this.parse(in, dbuilder);
        return dbuilder.getRoot();
    }

    public Parser() {
        this.setupDefaultEntities();
    }
}

