/*
 * Decompiled with CFR 0.152.
 */
package gexpa;

import gexpa.BuildEventListener;
import gexpa.Element;
import java.util.Hashtable;

public final class DOMBuilder
implements BuildEventListener {
    private Element root;
    private Element currentElement;
    private final Hashtable strings = new Hashtable();
    private final StringBuffer text = new StringBuffer();
    private boolean strictTextHandling = true;

    private String internalise(String string) {
        if (this.strings.containsKey(string)) {
            return (String)this.strings.get(string);
        }
        string = new String(string.toCharArray());
        this.strings.put(string, string);
        return string;
    }

    public void setStrictTextHandling(boolean handling) {
        this.strictTextHandling = handling;
    }

    public void startElementDeclaration(String name) {
        this.currentElement.setText(this.text.toString());
        name = this.internalise(name);
        Element element = new Element(name);
        this.currentElement.addElement(element);
        this.currentElement = element;
        this.text.setLength(0);
    }

    public void attribute(String name, String value) {
        name = this.internalise(name);
        value = this.internalise(value);
        this.currentElement.setAttribute(name, value);
    }

    public void endElementDeclaration(String name) {
    }

    public void closeElement(String name) {
        String text = this.text.toString();
        this.text.setLength(0);
        text = this.internalise(text);
        this.currentElement.setText(text);
        this.currentElement = this.currentElement.getParent();
        this.text.append(this.currentElement.getText());
    }

    public void elementText(String text) {
        if (!this.strictTextHandling && this.text.length() > 0) {
            return;
        }
        this.text.append(text);
    }

    public void startDocument() {
        this.root = this.currentElement = new Element();
    }

    public void finishDocument() {
    }

    public Element getRoot() {
        return (Element)this.root.getChildren().elementAt(0);
    }
}

